#if !defined __UNIO_H
#define __UNIO_H

// Filename: Unio.H
//
// Description:
//   Include file for Unio I/O Driver
//
// A.Kolegov (NIIATT) 30.08.1996
//

#include <ntddk.h>
#include <string.h>
#include <devioctl.h>
#include "unioctl.h"
#include "uniodef.h"


// NT device name
#define UNIO_DEVICE_NAME L"\\Device\\Unio0"

// File system device name. When you execute a CreateFile call to open the
// device, use "\\.\UnioDev", or, given C's conversion of \\ to \, use
// "\\\\.\\UnioDev"
#define DOS_DEVICE_NAME L"\\DosDevices\\UnioDev"

// driver local data structure specific to each device object
typedef struct _LOCAL_DEVICE_INFO {
    ULONG           DeviceType;       // Private Unio device type
    BOOLEAN         PortWasMapped;    // If TRUE, we have to unmap on unload
    PVOID           PortBase;         // Base port address
    ULONG           PortCount;        // Count of I/O addresses used
    ULONG           PortMemoryType;   // HalTranslateBusAddress MemoryType
    PDEVICE_OBJECT  DeviceObject;     // The Unio device object
} LOCAL_DEVICE_INFO, *PLOCAL_DEVICE_INFO;


// function prototypes

NTSTATUS DriverEntry(        IN  PDRIVER_OBJECT DriverObject,
                             IN  PUNICODE_STRING RegistryPath );

NTSTATUS UnioCreateDevice(   IN  PWSTR szPrototypeName,
                             IN  DEVICE_TYPE DeviceType,
                             IN  PDRIVER_OBJECT DriverObject,
                             OUT PDEVICE_OBJECT *ppDevObj     );

NTSTATUS UnioDispatch(       IN  PDEVICE_OBJECT pDO,
                             IN  PIRP pIrp                    );

NTSTATUS UnioIoctlReadPort(  IN  PLOCAL_DEVICE_INFO pLDI,
                             IN  PIRP pIrp,
                             IN  PIO_STACK_LOCATION IrpStack,
                             IN  ULONG IoctlCode              );

NTSTATUS UnioIoctlWritePort( IN  PLOCAL_DEVICE_INFO pLDI,
                             IN  PIRP pIrp,
                             IN  PIO_STACK_LOCATION IrpStack,
                             IN  ULONG IoctlCode              );

NTSTATUS UnioIoctlGetParams( IN  PLOCAL_DEVICE_INFO pLDI,
                             IN  PIRP pIrp,
                             IN  PIO_STACK_LOCATION IrpStack,
                             IN  ULONG IoctlCode              );

VOID     UnioUnload(         IN  PDRIVER_OBJECT DriverObject  );

#endif //__UNIO_H
